<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" />


<xsl:template match="/portfolio">
	<html>
		<head>
			<title><xsl:value-of select="title" /></title>
			<style type="text/css">
				html
					{
					font-family:	Tahoma;
					font-size:		8pt;
					margin:			0.5in;
					}

				table
					{
					font-size:		100%;
					}

				.title
					{
					font-size:		154%;
					font-weight:	bold;
					margin-top:		0;
					}

				.subtitle
					{
					font-size:		108%;
					font-weight:	bold;
					margin-bottom:	2em;
					}

				th
					{
					font-weight:	normal;
					background-color:	rgb(204,204,204);
					}

				.heading
					{
					font-weight:	bold;
					background-color:	rgb(240,240,240);
					border-top:		1px solid rgb(204,204,204);
					}

				.subtotal
					{
					font-weight:	bold;
					border-top:		1px solid rgb(204,204,204);
					padding-bottom:	0.5em;
					}

				.grandtotal
					{
					font-weight:	bold;
					border-top:		1px solid rgb(204,204,204);
					padding-top:	0.5em;
					}

				.data
					{
					}
			</style>
		</head>
		<body>
			<center>
				<div class="title"><xsl:value-of select="title" /></div>
				<div class="subtitle"><xsl:value-of select="subtitle" /></div>
			</center>
			<table cellpadding="2" cellspacing="0" width="100%">
				<xsl:apply-templates select="headers" />
				<tbody>
					<xsl:apply-templates select="rows/row" />
				</tbody>
			</table>
		</body>
	</html>
</xsl:template>


<xsl:template match="headers">
	<thead>
		<tr>
			<xsl:apply-templates select="header[(@displaytype != 8) and (@displaytype != 10) and (@displaytype != 11)]" />
		</tr>
	</thead>
</xsl:template>


<xsl:template match="rows">
	<tbody>
		<xsl:apply-templates select="row" />
	</tbody>
</xsl:template>


<xsl:template name="count-columns">
	<xsl:value-of select="count(/portfolio/headers/header[(@displaytype != 8) and (@displaytype != 10) and (@displaytype != 11)])" />
</xsl:template>


<xsl:template match="header">
	<th>
		<xsl:attribute name="align"><xsl:value-of select="@align" /></xsl:attribute>
		<xsl:call-template name="text"><xsl:with-param name="node" select="." /></xsl:call-template>
	</th>
</xsl:template>


<xsl:template match="row">
	<tr>
		<xsl:apply-templates select="value[(@displaytype != 8) and (@displaytype != 10) and (@displaytype != 11)]">
			<xsl:with-param name="rowType" select="@type" />
			<xsl:with-param name="colspan">
				<xsl:if test="@type = 'heading'"><xsl:call-template name="count-columns" /></xsl:if>
			</xsl:with-param>
		</xsl:apply-templates>
	</tr>
</xsl:template>


<xsl:template match="value">
	<xsl:param name="rowType" />
	<xsl:param name="colspan" select="1" />
	<td>
		<xsl:attribute name="class"><xsl:value-of select="$rowType" /></xsl:attribute>
		<xsl:attribute name="align"><xsl:value-of select="@align" /></xsl:attribute>
		<xsl:if test="$colspan &gt; 1"><xsl:attribute name="colspan"><xsl:value-of select="$colspan" /></xsl:attribute></xsl:if>
		<xsl:attribute name="style">color: <xsl:value-of select="@color" />;</xsl:attribute>
		<xsl:call-template name="text"><xsl:with-param name="node" select="." /></xsl:call-template>
	</td>
</xsl:template>


<xsl:template name="text">
	<xsl:param name="node" />
	<xsl:choose>
		<xsl:when test="string-length(.) = 0">
			<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="." />
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


</xsl:stylesheet>

